﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Transactions;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.DAL;

namespace AZVIC.Ei8htPOS.BAL
{
    [DataObjectAttribute()]
    public static class AuditTrailBL
    {
        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static AuditTrail GetItem(Guid auditTrailID, Guid referenceID)
        {
            return AuditTrailDB.GetItem(auditTrailID, referenceID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static List<AuditTrail> GetList(Guid auditTrailID, Guid referenceID)
        {
            return AuditTrailDB.GetList(auditTrailID, referenceID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataTable GetDataTable(Guid auditTrailID, Guid referenceID)
        {
            return AuditTrailDB.GetDataTable(auditTrailID, referenceID);
        }

        [DataObjectMethod(DataObjectMethodType.Select, false)]
        public static DataSet GetDataSet(Guid auditTrailID, Guid referenceID)
        {
            return AuditTrailDB.GetDataSet(auditTrailID, referenceID);
        }

        [DataObjectMethod(DataObjectMethodType.Update, true)]
        public static bool Save(Guid referenceID, string ipAddress, string remarks, Guid userAccountID, Guid adminUserAccountID)
        {
            using (TransactionScope myTransactionScope = new TransactionScope())
            {
                AuditTrail myAuditTrail = new AuditTrail();
                myAuditTrail.Mode = Utilities.GlobalConfigurations.Mode.Insert;
                myAuditTrail.ReferenceID = referenceID;
                myAuditTrail.IPAddress = ipAddress;
                myAuditTrail.Remarks = remarks;
                myAuditTrail.UserAccountID = userAccountID;
                myAuditTrail.AdminUserAccountID = adminUserAccountID;
                myAuditTrail.IsActive = true;

                AuditTrailDB.Save(myAuditTrail);

                myTransactionScope.Complete();
                return true;
            }
        }
    }
}
